#include <unistd.h>

#include "net_test.h"


IF_THREAD_LIST *list;


#ifdef DEBUG_SERVER

// //////////////////////////////////////////////////////////////
void sighandler(int s)
{
}
// //////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////
void * th_func(THREAD_STATE *state, int id, void *data)
{
	char *buf;
	int n, q;

	buf = if_malloc(PATH_LEN);

	//if_thread_mutex_lock(list);
	for (q = 0 ; (n = readln_timeout(id, buf, PATH_LEN, 30)) > 0 ; q++)
		send_bytes(id, buf, n, 1);
	//if_thread_mutex_unlock(list);

	verbose(stdout, "ID: %d - Qty: %d\n", id, q);
	if_closesocket(id);
	if_free(buf);

	return(NULL);
}
// //////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////
int main(int argc, char *argv[])
{
	int ssock, sock, clilen;
	struct sockaddr_in cli_addr;

	if (argc < 2)
	{
		fprintf(stderr, "Uso:\nshell$ %s <PORT>\n", argv[0]);
		return(1);
	}

	signal(SIGPIPE, sighandler);

	fprintf(stdout, "Inicia (%d).\n", getpid());
	list = if_thread_list_new(if_thread_event_debug);

	ssock = openServerTCP(argv[1]);
	
	while (1)
	{
		clilen = sizeof(struct sockaddr);
		sock = accept_timeout(ssock, 1, (struct sockaddr *) &cli_addr, &clilen);
		if (sock == 0)
			continue;

		if (sock < 0)
			break;

		if_thread_add(list, th_func, sock, NULL);
	}
	
	fprintf(stdout, "Finaliza lista.\n");
	if_thread_list_finalize(list);
	fprintf(stdout, "Espera lista.\n");
	if_thread_list_wait(list);

	fprintf(stdout, "Encerra (%d).\n", getpid());
	return(0);
}
// //////////////////////////////////////////////////////////////
#else
#define DURATION	5

// //////////////////////////////////////////////////////////////
void * cli_func(THREAD_STATE *state, int id, void *data)
{
	//char msg[] = "teste cliente TCP.\n";
	char path[] = "index.html";
	char **argv = (char **) data;
	//char buf[PATH_LEN];
	char *host, *port, *resp;
	//int sock, n, i;

	host = argv[1];
	port = argv[2];

	send_http_post(host, port, path, "x=1", &resp);
	if (resp == NULL)
		fprintf(stderr, "erro ao tentar acessar %s:%s/%s\n", host, port, path);
	else
	{
		fprintf(stdout, "RESP -->%s<--\n", resp);
		if_free(resp);
	}

/*	sock = openTCP(host, port, 1);
	if (sock == 0)
	{
		fprintf(stderr, "timeout.\n");
		return(NULL);
	}
	else if (sock < 0)
	{
		fprintf(stderr, "falha.\n");
		return(NULL);
	}

	for (i = 0 ; i < DURATION ; i++)
	{
		sleep(1);
		n = send_bytes(sock, msg, strlen(msg), 1);

		if ((n = read_bytes(sock, buf, PATH_LEN, 1)) < 1)
			break;
	}

	if_closesocket(sock);
*/
	return(NULL);
}
// //////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////
int main(int argc, char *argv[])
{
	int qty, i, k = 1;

	if (argc < 4)
	{
		fprintf(stderr, "Uso:\nshell$ %s <IP> <PORT> <QTY CONN>\n", argv[0]);
		return(1);
	}

	fprintf(stdout, "Inicia Cliente (%d).\n", getpid());

	list = if_thread_list_new(if_thread_event_debug);

	qty = atoi(argv[3]);
	while (1)
	{
		for (i = 0 ; i < qty ; i++)
			if_thread_add(list, cli_func, k++, argv);

		sleep(DURATION - 2);
	}
	
	fprintf(stdout, "Finaliza lista (cliente).\n");
	if_thread_list_finalize(list);
	fprintf(stdout, "Espera lista (cliente).\n");
	if_thread_list_wait(list);

	fprintf(stdout, "Encerra (%d).\n", getpid());
	return(0);
}
// //////////////////////////////////////////////////////////////

#endif




