#include <ifractal.h>
#include <modXXXXload.h>

#define CONFIG_INI	"conf/upload.ini"
#define MODULE		"MODUPLOAD"

#define verbose3(ref,def,format,...)	verbose2(ref,def,stdout,MODULE,format, ##__VA_ARGS__)

extern IF_GETOPT XXXXload_config[];

IF_THREAD_LIST *thread_list = NULL;

#if defined(STANDALONE) || defined (IFMODULE)
IF_VERBOSITY verbosity = IF_VERB_NONE;
#else
extern IF_VERBOSITY verbosity;
#endif


// //////////////////////////////////////////////////////////////////////
// Considera timeout para velocidades inferiores a 1KBps
_CALLBACK int modupload_send_timeout_cb(void *user_data, double dltotal, double dlnow, double ultotal, double ulnow)
{
	time_t *start = (time_t *) user_data;
	int to = 60 + (dltotal + ultotal) / (1 * 1024);
	int elapsed = time(NULL) - *start;

	if (elapsed > to)
	{
		verbose3(verbosity, IF_VERB_WARN, "Timeout - Elapsed: %d segs  -  Vel: %0.03lf KBps\n",
			elapsed, (dlnow + ulnow) / (double) (1024 * elapsed));
		return(1);
	}

	return(0);
}
// //////////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////////
_CALLBACK int modupload_make_post_iter(char *key, JSON_VALUE *value, void *user_data)
{
	char **post_list = (char **) user_data;
	int i;

	for (i = 0 ; (i < PATH_LEN) && (post_list[i] != NULL) ; i++)
		;

	if (i >= PATH_LEN)
		return(1);

	post_list[i++] = key;
	post_list[i] = json_get_string(value);

	return(0);
}
// //////////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////////
_PRIVATE int modupload_move(FILE_CONTEXT *fctx, char *dest)
{
	char to[PATH_LEN];
	int r;

	snprintf(to, PATH_LEN, "%s%c%s", dest, PATH_SEPARATOR, fctx->name);

	r = modXXXXload_rename(to, fctx->filename);
	return(r);
}
// //////////////////////////////////////////////////////////////////////
_PRIVATE int modupload_callback(_IN char *filename, _IN char *resp, _IN JSON_VALUE *jcallback)
{
	char *post_list[PATH_LEN] = {"filename", filename, "return", resp, NULL, NULL};
	char *buf, ok[] = "OK", *urlcallback;
	JSON_VALUE *aux;
	time_t start;
	URL *url;
	int n;

	if ((jcallback == NULL) || (json_get_type(jcallback) != JSON_OBJECT_TYPE))
		return(0);

	aux = json_object_find(jcallback, "url");
	if (aux == NULL)
		return(0);

	if ((urlcallback = json_get_string(aux))[0] == 0)
		return(0);

	url = url_new(urlcallback);

	aux = json_object_find(jcallback, "post");
	if (aux != NULL)
		json_object_iter(aux, modupload_make_post_iter, post_list);

	start = time(NULL);
	n = url_execute_post(url, post_list, (unsigned char **) &buf, modupload_send_timeout_cb, &start);
	if (buf != NULL)
	{
		verbose3(verbosity, IF_VERB_INFO, "Callback Resp: -->%s<--\n", buf);
		if (strncmp(buf, ok, strlen(ok)) != 0)
			verbose3(verbosity, IF_VERB_FATAL, "Upload nao confirmado.\n", buf);

		free(buf);
	}

	url_free(url);

	return(n);
}
// //////////////////////////////////////////////////////////////////////


// //////////////////////////////////////////////////////////////////////
_PRIVATE int modupload_fs_send(FILE_CONTEXT *fctx, void *user_data)
{
	void **data = (void **) user_data;
	char **configs = (char **) data[0];
	JSON_VALUE *jpost = (JSON_VALUE *) data[1];
	JSON_VALUE *jcallback = (JSON_VALUE *) data[2];
	char *post_list[PATH_LEN];
	char *file_list[4];
	char *url, *resp = NULL;
	time_t start;
	URL *urlobj;
	int n;

	memset(post_list, 0, sizeof(post_list));

	url = json_get_list_param(configs, "url");
	urlobj = url_new(url);

	verbose3(verbosity, IF_VERB_INFO, "Req: %s:%s/%s (%s)\n", urlobj->host, urlobj->port, urlobj->path, fctx->name);

	json_object_iter(jpost, modupload_make_post_iter, post_list);

	file_list[0] = json_get_list_param(configs, "file_param_name");
	file_list[1] = fctx->filename;
	file_list[2] = NULL;
	file_list[3] = NULL;

	start = time(NULL);
	n = url_execute_upload(urlobj, post_list, file_list, (unsigned char **) &resp, modupload_send_timeout_cb, &start);

	verbose3(verbosity, IF_VERB_INFO, "Resp -->%s<--\n", resp);
	if (resp != NULL)
	{
		modXXXX_save_file(jpost, (unsigned char *) resp, n);

		modupload_callback(fctx->name, resp, jcallback);
		if_free(resp);

		if (modupload_move(fctx, json_get_list_param(configs, "bkppath")))
		{
			verbose3(verbosity, IF_VERB_FATAL, "Erro ao tentar mover '%s' para '%s'\n", 
				fctx->name, json_get_list_param(configs, "bkppath"));
		}
	}
	else
		modupload_move(fctx, json_get_list_param(configs, "errpath"));

	url_free(urlobj);

	return(n);
}
// //////////////////////////////////////////////////////////////////////
_CALLBACK int modupload_fs_cb(DIR_CONTEXT *dir, FILE_CONTEXT *fctx, void *user_data)
{
	void **data = (void **) user_data;
	char **configs = (char **) data[0];
	char *prefix, *suffix;

	if (fctx->type != FILE_TYPE_REGULAR)
		return(0);

	prefix = json_get_list_param(configs, "prefix");
	suffix = json_get_list_param(configs, "suffix");

	if (!fs_file_check(fctx, prefix, suffix))
		return(0);

	modupload_fs_send(fctx, user_data);

	return(0);
}
// //////////////////////////////////////////////////////////////////////
_CALLBACK int delete_cb(char *path, char *filename, void *user_data)
{
	verbose3(verbosity, IF_VERB_INFO, "'%s' deletado.\n", filename);
	return(0);
}
// //////////////////////////////////////////////////////////////////////
_PUBLIC int modupload_perform(JSON_VALUE *jconf, int *count)
{
	DIR_CONTEXT *dir;
	char *configs[] = {
		"inpath",".", 
		"bkppath","bkp", 
		"errpath","err", 
		"url","http://ifractal.srv.br/test", 
		"prefix","",
		"suffix",".xml",
		"freq","5",
		"file_param_name","file",
		"delete","30",
		"sort","",
		NULL,NULL
		};
	char *inpath, *bkppath, *prefix, *suffix;
	int qtdias, n;

	json_make_list_param(jconf, configs);

	bkppath = json_get_list_param(configs, "bkppath");
	prefix = json_get_list_param(configs, "prefix");
	suffix = json_get_list_param(configs, "suffix");
	qtdias = atoi(json_get_list_param(configs, "delete"));

	n = execute_delete(bkppath, prefix, suffix, qtdias, 0, delete_cb, NULL);
	if (n > 0)
		verbose3(verbosity, IF_VERB_INFO, "Arquivos deletados: %d (%d dias).\n", n, qtdias);

	inpath = json_get_list_param(configs, "inpath");
	dir = fs_dir_new(inpath);
	if (dir == NULL)
	{
		verbose(stderr, "|%s| Falha ao tentar abrir diretorio: '%s'\n", MODULE, inpath);
		return(0);
	}

	void *data[] = {
		configs,
		json_object_find(jconf, "post"),
		json_object_find(jconf, "callback"),
		NULL
	};

	char *sort = json_get_list_param(configs, "sort");

	if (strcmp(sort, "n") == 0)
		fs_dir_name_sorted_iter(dir, modupload_fs_cb, 0, data);
	else if (strcmp(sort, "nd") == 0)
		fs_dir_name_sorted_iter(dir, modupload_fs_cb, 1, data);
	else if (strcmp(sort, "t") == 0)
		fs_dir_time_sorted_iter(dir, modupload_fs_cb, 0, data);
	else if (strcmp(sort, "td") == 0)
		fs_dir_time_sorted_iter(dir, modupload_fs_cb, 1, data);
	else
		fs_dir_iter(dir, modupload_fs_cb, data);

	fs_dir_free(dir);

	return(0);
}
// //////////////////////////////////////////////////////////////////////




#ifdef STANDALONE
#define DESCRIPT	"Processo de upload de arquivos."

// //////////////////////////////////////////////////////////////////////
int main (int argc, char **argv)
{
	THREAD_STATE state = TH_ALIVE;
	int r;
	
	r = if_getopt(XXXXload_config, argc, argv);
	if (	(r) || 
		!if_getopt_isChecked(XXXXload_config, "CONFIG")
	)
	{
		if_help_header(argv[0], DESCRIPT);
		fprintf(stderr, "Ajuda:\n");
		if_getopt_help(XXXXload_config);

		fprintf(stderr, "\nUso:\n");
		fprintf(stderr, "\tshell$ %s -c <JSON_CONFIG>\n", argv[0]);

		fprintf(stderr, "\nExemplo:\n");
		fprintf(stderr, "\tshell$ %s -c upload.json\n", argv[0]);

		fprintf(stderr, "\nExemplo arquivo:\n\n%s\n\n", UPLOAD_JSON_CONFIG);

		fprintf(stderr, "\n");

		return(r);
	}

	verbosity = atoi(if_getopt_getValue(XXXXload_config, "VERBOSITY"));

	modXXXXload_run(&state, 1, modupload_perform);

	return(0);
}
// //////////////////////////////////////////////////////////////////////

#endif


#ifdef IFMODULE

// Implementacao da Interface ///////////////////////////////////////////
_PUBLIC int if_modweb_init(IF_MODWEB *mod)
{
	thread_list = if_thread_list_new(NULL);

	verbose3(verbosity, IF_VERB_INFO, "Le configuracao: %s.\n", CONFIG_INI);
	if_getopt_ini(CONFIG_INI, XXXXload_config);

	verbosity = atoi(if_getopt_getValue(XXXXload_config, "VERBOSITY"));
	verbose(stdout, "|%s| VERBOSITY = %d\n", MODULE, verbosity);

	if_thread_add(thread_list, modXXXXload_run, 1, modupload_perform);
	
	modweb_define_conf(mod, XXXXload_config, CONFIG_INI);
	modweb_define_info(mod, "Upload", "Modulo para envio de arquivos HTTP/HTTPS.", "upload.png");

	return(0);
}
// //////////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////////
_PUBLIC int if_modweb_finalize(IF_MODWEB *mod)
{
	if_thread_list_finalize(thread_list);
	if_thread_list_wait(thread_list);
	FREE(thread_list);

	return(0);
}
// //////////////////////////////////////////////////////////////////////
// FIM - Implementacao da Interface /////////////////////////////////////

#endif
