#include <ifractal.h>

#include <jni.h>

#define MODULE	"modjava"

typedef struct
{
	char classname[PATH_LEN];
	jclass klass;
	jobject object;
} JAVA_INSTANCE;

typedef struct
{
	JavaVM *jvm;
	JNIEnv *env;
	uint16_t qty;
	JAVA_INSTANCE *instances;
} JAVA_CONTEXT;

JAVA_CONTEXT * java_init_context(char *classpath, char *library_path, char *stack);
int java_new_class(JAVA_INSTANCE *, JNIEnv *, char *classname, jobjectArray);
JAVA_INSTANCE * java_get_object(char *classname);

