#include <ifractal.h>
#include <ifdevice.h>

char *IFPONTO_IDs[] = {"id", "pis", "cracha", "matricula", "codigo", "code", NULL};

IF_GETOPT ifponto_config[] = {
	{0, 'e', IF_GETOPT_TYPE_NUMBER, "ATIVO", "1", 0, "0 = Modulo inativo, 1 = ativo"},
	{0, 'e', IF_GETOPT_TYPE_NUMBER, "MODO", "0", 0, "0 = offline, 1 = online"},
	{0, 'x', IF_GETOPT_TYPE_NUMBER, "SYNCTIME", "1", 0, "0 = Nao sincroniza relogio, 1 = Sincroniza (default)"},
	{0, 'x', IF_GETOPT_TYPE_NUMBER, "QTD_OFF_FILES", "50", 0, "Quantidades de arquivos offs por ciclo."},
	{0, 'c', IF_GETOPT_TYPE_HIDDEN, "CLIENTID", "", 0, "URL PATH da conta do cliente."},
	{0, 'x', IF_GETOPT_TYPE_STRING, "CHAVE", "", 0, "Chave de comunicacao."},
	{0, 'r', IF_GETOPT_TYPE_STRING, "READERS", "", 0, "Lista de leitores a serem inicializados. A lista deve conter os numeros dos leitores separados por virgula."},
	{0, 'x', IF_GETOPT_TYPE_STRING, "CENTRALIZADORES", "", 0, "Lista de leitores centralizadores de biometria."},
	{0, 'x', IF_GETOPT_TYPE_STRING, "TIMEDIFF", "", 0, "Diferenca em horas em relacao ao servidor. Ex: 1;-2,3;1  (Leitor nro 1; -2 horas, nro 3; +1 hora)"},
	{0, 'x', IF_GETOPT_TYPE_STRING, "ID", "", 0, "Identificacao da instalacao do modulo no sistema"},
	{0, 'v', IF_GETOPT_TYPE_SELECT, "VERBOSITY", "4", 0, VERBOSITY_OPTIONS},
	{0, 'x', IF_GETOPT_TYPE_SELECT, "VERBOSITY_PORT", "9001", 0, VERBOSITY_OPTIONS},
	{0, 'h', IF_GETOPT_TYPE_HIDDEN, "WEBHOST", IFRACTALSRV, 0, "HOST ifPonto."},
	{0, 'p', IF_GETOPT_TYPE_HIDDEN, "WEBPORT", "443", 0, "PORT (WEB) do Sistema iFractal."},
	{0, 'x', IF_GETOPT_TYPE_HIDDEN, "SIIN_PATH", SIIN_PATH_DEFAULT, 0, "PATH comunicacao com sistema."},
	{0, 'x', IF_GETOPT_TYPE_HIDDEN, "ONLINE", ONLINE_DEFAULT, 0, "PATH para o envio de eventos/mensagens."},
	{0, 'x', IF_GETOPT_TYPE_NUMBER, "LOOP", "50", 0, "Intervalo em segundos de cada requisicao ao sistema."},
	{0, 'x', IF_GETOPT_TYPE_STRING, "WS", "http://127.0.0.1:9010/ws", 0, "URL WebService."},
	{0, 'c', IF_GETOPT_TYPE_NUMBER, "PATH_LOG", "log", 0, "PATH da pasta log ."},
	{0, 'c', IF_GETOPT_TYPE_NUMBER, "PATH_OFF", "off", 0, "PATH da pasta off."},

	// Desktop REP
	{0, 'x', IF_GETOPT_TYPE_STRING, "HAMSTER_LIB", "futronic", 0, "Arquivo(plugin) de integração com o hamster"},
	{0, 'x', IF_GETOPT_TYPE_HIDDEN, "PASS", "0", 0, "Senha"},
	{0, 'x', IF_GETOPT_TYPE_NUMBER, "OPTIONS", "0", 0, "Mapa de bits dos checks - Desktop REP."},
	{0, 'x', IF_GETOPT_TYPE_NUMBER, "PIS_DEFAULT", "", 0, "Pis do usuario default selecionado para realizar o registro."},
	{0, 0, 0, 0, 0, 0, 0}
};


struct _HAMSTERS HAMSTERS[] = {
#if _WIN64 || __amd64__
	{"DigitalPersona", "digitalpersona", "digitalpersona"},
	{"Nitgen Hamster", "nhamster", "nitgen"},
	{"Nitgen BioScan", "nscan", "nitgen"},
	{"IB Watson Mini", "ib", "ib"},
	{"Suprema RealScan", "realscan", "suprema"},
#else
	{"Futronic", "futronic", "futronic"},
	{"Suprema", "suprema", "suprema"},
	{"IDBio", "idbio", "controlid"},
#endif
	{NULL, NULL, NULL}
};
	
// Compatibilidade com legado
char *BIO_vendor_encode[][2] = {
	{"suprema", TXT_ENCODE_HEX},
	{"sagem", TXT_ENCODE_RAW},
	{"nitgen", TXT_ENCODE_RAW},
	{NULL, NULL}
};

char *IFPONTO_OFF_JSON_FILE = IFPONTO_OFF_JSON_FILE_DEFAULT;
char *IFPONTO_STATUS_FILE = IFPONTO_STATUS_FILE_DEFAULT;
char *IFPONTO_CONFIG_FILE = IFPONTO_CONFIG_FILE_DEFAULT;
char *IFPONTO_LIST_FILE = IFPONTO_LIST_FILE_DEFAULT;
char *IFPONTO_CARD_FILE = IFPONTO_CARD_FILE_DEFAULT;
char *IFPONTO_PREBIO_FILE = IFPONTO_PREBIO_FILE_DEFAULT;
char *IFPONTO_BIO_FILE = IFPONTO_BIO_FILE_DEFAULT;
char *IFPONTO_OFF_BIO_FILE = IFPONTO_OFF_BIO_FILE_DEFAULT;
char *IFPONTO_RESULT_FILE = IFPONTO_RESULT_FILE_DEFAULT;

typedef struct
{
	char *mask;
	char *prefix;
	char **ref;
	char buf[PATH_LEN];
} FILE_MASK;

FILE_MASK file_mask[] = {
	{IFPONTO_OFF_JSON_FILE_DEFAULT, "off", &IFPONTO_OFF_JSON_FILE},
	{IFPONTO_RESULT_FILE_DEFAULT, "off", &IFPONTO_RESULT_FILE},
	{IFPONTO_STATUS_FILE_DEFAULT, "log", &IFPONTO_STATUS_FILE},
	{IFPONTO_CONFIG_FILE_DEFAULT, "log", &IFPONTO_CONFIG_FILE},
	{IFPONTO_LIST_FILE_DEFAULT, "log", &IFPONTO_LIST_FILE},
	{IFPONTO_CARD_FILE_DEFAULT, "log", &IFPONTO_CARD_FILE},
	{IFPONTO_PREBIO_FILE_DEFAULT, "log", &IFPONTO_PREBIO_FILE},
	{IFPONTO_BIO_FILE_DEFAULT, "log", &IFPONTO_BIO_FILE},
	{IFPONTO_OFF_BIO_FILE_DEFAULT, "off", &IFPONTO_OFF_BIO_FILE},
	{NULL, NULL, NULL}
};

void init_config_masks()
{
	char *path_log = if_getopt_getValue(ifponto_config, "PATH_LOG");
	char *path_off = if_getopt_getValue(ifponto_config, "PATH_OFF");
	int prefix_len;

	for(int i = 0 ; file_mask[i].mask != NULL ; i++)
	{
		prefix_len = strlen(file_mask[i].prefix);

		if((strcmp(file_mask[i].prefix, "off") == 0) && (path_off != NULL && path_off[0] != 0))
			snprintf(file_mask[i].buf, PATH_LEN, "%s%c%s", path_off, PATH_SEPARATOR, file_mask[i].mask + prefix_len + 1);
		else if((strcmp(file_mask[i].prefix, "log") == 0) && (path_log != NULL && strcmp(path_log, "")))
			snprintf(file_mask[i].buf, PATH_LEN, "%s%c%s", path_log, PATH_SEPARATOR, file_mask[i].mask + prefix_len + 1);

		*(file_mask[i].ref) = file_mask[i].buf;
	}
}

// /////////////////////////////////////////////////////////////////// //
_PRIVATE char * scanner_get_msg(SCANNER_RESULT res)
{
	switch(res)
	{
		case SCANNER_RESULT_OK: return("Ok");
		case SCANNER_RESULT_MODULE_ERROR: return("Erro ao tentar iniciar modulo");
		case SCANNER_RESULT_SCANNER_ERROR: return("Erro ao tentar iniciar scanner");
		case SCANNER_RESULT_CAPTURE_ERROR: return("Falha ao tentar capturar biometria");
		case SCANNER_RESULT_IDENTIFY_DB_ERROR: return("Erro ao tentar acessar biometrias na base de dados");
		case SCANNER_RESULT_IDENTIFY_ERROR: return("Falha ao tentar identificar biometria");
		case SCANNER_RESULT_VERIFY_ERROR: return("Falha ao tentar verificar biometria");
		case SCANNER_RESULT_BIO_NOT_FOUND: return("Biometria não localizada");
		case SCANNER_RESULT_BIO_NOT_ENROLLED: return("Nenhuma biometria cadastrada");
		case SCANNER_RESULT_INVALID_PARAMETERS: return("Parametros invalidos");
		case SCANNER_RESULT_ENROLL_DB_ERROR: return("Erro ao tentar salvar biometria no banco de dados");
		case SCANNER_RESULT_DELETE_ERROR: return("Erro ao tentar deletar biometrias");
		case SCANNER_RESULT_UP_FIRMWARE_ERROR: return("Erro ao tentar atualizar o firmware");
		case SCANNER_RESULT_EXTRACT_ERROR: return("Erro ao tentar extrair biometria");
	}
	return("Erro");
}

// /////////////////////////////////////////////////////////////////// //
int print_mask_2(FILE *fd, char *mask, int p1, int p2)
{
	char linha[1024];
	int i = 0, len = 0, max = p1, t;
	char *tk[10];

	if(p2 > p1)
		max = p2;

	for( ; fgets(linha, sizeof(linha), fd) != NULL ; i++)
	{
		linha[strlen(linha)-1] = 0;
		t = tokenizer('|', linha, tk, sizeof(tk) / sizeof(char *));
		if(t <= max)
			continue;

		len += fprintf(stdout, mask, tk[p1], tk[p2]);
	}

	return(len);
}

// /////////////////////////////////////////////////////////////////// //
#define IFPONTO_CONFIG_HEADER	"// Arquivo Gerado automaticamente - NAO ALTERE\n\n" 					\
				"package com.ifractal.ifponto;\n\n"							\
				"import java.util.*;\n"									\
				"\n"											\
				"public class IFPONTO_config\n"								\
				"{\n"											\
				"	public static final String filename = \""					\
				CONFIG_INI										\
				"\";\n\n"										

#define IFPONTO_CONFIG_MET	"\n\n	public static HashMap<String,String> getParams()\n"				\
				"	{\n"										\
				"		HashMap<String,String> params = new HashMap<String,String>();\n"	\
				"\n"

#define IFPONTO_CONFIG_AFTER	"\n"							\
				"		return(params);\n"			\
				"	}\n\n"						\
				"	public static String getMsg(int res)\n"		\
				"	{\n"						\
				"		switch(res)\n"				\
				"		{\n"

#define IFPONTO_CONFIG_LAST	"		}\n"					\
				"		return(\"Erro\");\n"			\
				"	}\n"						\
				"}\n"

int java_ifponto_config(FILE *fd)
{
	int len = 0;
	len += fprintf(stdout, "%s", IFPONTO_CONFIG_HEADER);

	len += print_mask_2(fd, "	public static final int %s = %s;\n", 0, 1);

	len += fprintf(stdout, "\n	public static final String[] IDs = {\"%s\"", IFPONTO_IDs[0]);
	for(int i = 1 ; IFPONTO_IDs[i] != NULL ; i++)
		len += fprintf(stdout, ", \"%s\"", IFPONTO_IDs[i]);
	len += fprintf(stdout, "};\n");

	len += fprintf(stdout, "%s", IFPONTO_CONFIG_MET);

	for (int i = 0 ; ifponto_config[i].long_opt != NULL ; i++)
	{
		len += fprintf(stdout, "\t\tparams.put(\"%s\", \"%s\");\n", 
			ifponto_config[i].long_opt,
			ifponto_config[i].arg);
	}

	len += fprintf(stdout, "%s", IFPONTO_CONFIG_AFTER);

	rewind(fd);
	len += print_mask_2(fd, "			case %s: return(\"%s\");\n", 0, 2);

	len += fprintf(stdout, "%s", IFPONTO_CONFIG_LAST);

	return(len);
}

// /////////////////////////////////////////////////////////////////// //
int h_result_config(FILE *fd)
{
	int len = 0;
	len += fprintf(stdout, "%s", "// Arquivo Gerado automaticamente - NAO ALTERE\n\n");
	len += fprintf(stdout, "char * result_get_msg(int res);\n\n");
	len += print_mask_2(fd, "#define RESULT_%s\t%s\n", 0, 1);

	return(len);
}

// /////////////////////////////////////////////////////////////////// //
#define C_RESULT_HEADER "// Arquivo Gerado automaticamente - NAO ALTERE\n\n"	\
			"#include <result_config.h>\n\n"			\
			"char * result_get_msg(int res)\n"			\
			"{\n"							\
			"	switch(res)\n"					\
			"	{\n"

#define C_RESULT_AFTER	"	}\n"			\
			"	return(\"Erro\");\n"	\
			"}"				\

int c_result_config(FILE *fd)
{
	int len = 0;

	len += fprintf(stdout, "%s", C_RESULT_HEADER);

	len += print_mask_2(fd, "		case RESULT_%s: return(\"%s\");\n", 0, 2);

	len += fprintf(stdout, "%s", C_RESULT_AFTER);

	return(len);
}

// /////////////////////////////////////////////////////////////////// //
#define CS_RESULT_HEADER "// Arquivo Gerado automaticamente - NAO ALTERE\n\n"	\
			"namespace ifponto\n"					\
			"{\n"							\
			"	public class Result\n"			\
			"	{\n"

#define CS_RESULT_AFTER	"\n\n		public static string GetMsg(int res)\n"	\
			"		{\n"					\
			"			switch(res)\n"			\
			"			{\n"				\

#define CS_RESULT_LAST	"			}\n"					\
			"			return(\"Erro\");\n"			\
			"		}\n"						\
			"	}\n"							\
			"}\n"								\

int cs_result_config(FILE *fd)
{
	int len = 0;
	len += fprintf(stdout, "%s", CS_RESULT_HEADER);

	len += print_mask_2(fd, "		public const int %s = %s;\n", 0, 1);

	len += fprintf(stdout, "\n		public static string[] IDs = new string[]{\"%s\"", IFPONTO_IDs[0]);
	for(int i = 1 ; IFPONTO_IDs[i] != NULL ; i++)
		len += fprintf(stdout, ", \"%s\"", IFPONTO_IDs[i]);
	len += fprintf(stdout, "};\n");

	len += fprintf(stdout, "%s", CS_RESULT_AFTER);

	rewind(fd);
	len += print_mask_2(fd, "				case %s: return(\"%s\");\n", 0, 2);

	len += fprintf(stdout, "%s", CS_RESULT_LAST);

	return(len);
}

// /////////////////////////////////////////////////////////////////// //


#ifdef STANDALONE

// /////////////////////////////////////////////////////////////////// //
int main(int argc, char *argv[])
{
	FILE *fd;
	struct
	{
		char *nome;
		int (*func)(FILE *);
	} tipo[] = {
		{"jifponto", java_ifponto_config},
		{"hresult", h_result_config},
		{"cresult", c_result_config},
		{"csresult", cs_result_config},
		{NULL, NULL}
	};

	if(argc < 3)
	{
		fprintf(stderr, "Uso:\n\t$ %s <tipo> <CSV>\n\n", argv[0]);
		fprintf(stderr, "Onde <tipo>:\n");

		for(int i = 0 ; tipo[i].nome != NULL ; i++)
			fprintf(stderr, "\t%d - %s\n", i, tipo[i].nome);

		fprintf(stderr, "\nExemplo:\n\t$ %s 1 table_results.csv\n\n", argv[0]);
		return(1);
	}

	int max = 0;
	for(int i = 0 ; tipo[i].nome != NULL ; i++, max++)
		;

	int cod = atoi(argv[1]);
	if((cod >= max) || (cod < 0))
	{
		fprintf(stderr, "Tipo '%d' invalido.\n", cod);
		return(2);
	}

	if(argv[2][0] == '-')
		fd = stdin;
	else
		fd = fopen(argv[2], "r");

	if (fd == NULL)
	{
		fprintf(stderr, "Falha ao tentar abrir arquivo '%s'", argv[2]);
		return(3);
	}

	tipo[cod].func(fd);
	fclose(fd);

	return(0);
}
// /////////////////////////////////////////////////////////////////// //

#endif
