#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "if_string.h"


// ////////////////////////////////////////////////////////////
void string_init(STRING_BUFFER *buf, char *text)
{
	buf->text = strdup(text);
	buf->length = strlen(text);
	buf->size = buf->length + 1;
}
// ////////////////////////////////////////////////////////////
STRING_BUFFER * string_new(char *text)
{
	STRING_BUFFER *buf;

	buf = malloc(sizeof(STRING_BUFFER));
	memset(buf, 0, sizeof(STRING_BUFFER));

	if (text != NULL)
		string_init(buf, text);

	return(buf);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
void string_free(STRING_BUFFER *buf)
{
	if (buf == NULL)
		return;

	if (buf->text != NULL)
		free(buf->text);

	free(buf);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
int string_resize(STRING_BUFFER *buf, char *text)
{
	int len = strlen(text);

	if ((buf->size - buf->length) <= len)
	{
		buf->size = 2 * (buf->size + len);
		buf->text = realloc(buf->text, buf->size);
	}

	return(len);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
int string_append(STRING_BUFFER *buf, char *text)
{
	char *p, *q;
	int len;

	if ((buf == NULL) || (text == NULL))
		return(0);

	if (buf->text != NULL)
	{
		len = string_resize(buf, text);

		//strcpy(buf->text + buf->length, text);
		for (p = buf->text + buf->length, q = text ; (*p++ = *q++) ; )
			;

		buf->length += len;
		buf->text[buf->length] = 0;
	}
	else
		string_init(buf, text);

	return(buf->size); 
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
int string_prepend(STRING_BUFFER *buf, char *text)
{
	int len, i;

	if ((buf == NULL) || (text == NULL))
		return(0);

	if (buf->text != NULL)
	{
		len = string_resize(buf, text);

		for (i = buf->length ; i >= 0 ; i--)
			buf->text[i + len] = buf->text[i];

		for (i = 0 ; i < len ; i++)
			buf->text[i] = text[i];

		buf->length += len;
	}
	else
		string_init(buf, text);

	return(buf->size); 
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
char * string_get_text(STRING_BUFFER *buf)
{
	return(buf->text);
}
// ////////////////////////////////////////////////////////////



#ifdef STR_DEBUG

// ////////////////////////////////////////////////////////////
int main(int argc, char **argv)
{
	STRING_BUFFER *buf;
	int i;

	buf = string_new(" ABC ");

	for (i = 0 ; i < 10 ; i++)
	{
		string_append(buf, "XYZ");
		string_prepend(buf, "123 456 789 012");
	}

	printf("'%s'\n", string_get_text(buf));

	string_free(buf);
	
	return(0);
}
// ////////////////////////////////////////////////////////////

#endif
