#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <ifractal_utils.h>

#ifdef WIN32
#include <windows.h>
#endif


// ///////////////////////////////////////////////////////////////////////////
int main(int argc, char **argv)
{
	IF_DB *db;
	IF_RESULTSET *rs;
	int qty, i;

	if (argc < 7)
	{
		fprintf(stderr, "Uso:\nshell$ %s <HOST> <PORT> <DB> <USER> <PASS> <QUERY>\n", argv[0]);
		return(1);
	}

	db = if_db_connect(argv[1], argv[2], argv[4], argv[5], argv[3], NULL);
	if (db == NULL)
	{
		fprintf(stderr, "Database Error\n");
		return(2);
	}

	fprintf(stdout, "Exec: \"%s\"\n", argv[6]);
	rs = if_db_query(db, argv[6], &qty, 0, 0);
	if (rs == NULL) 
	{
		if (qty >= 0)
		{
			fprintf(stdout, "Affected: %d\n", qty);
			if_db_close(db);
			return(0);
		}
		else
		{
			fprintf(stdout, "Erro.\n");
			if_db_close(db);
			return(3);
		}
	}

	for (i = 0 ; rs->fields[i] != NULL ; i++)
		fprintf(stdout, "%15s", rs->fields[i]);
	fprintf(stdout, "\n");

	for (i = 0 ; i < rs->num_fields ; i++)
		fprintf(stdout, "%15.02lf", rs->sub_sums[i]);
	fprintf(stdout, "\n");

	for (i = 0 ; i < rs->num_fields ; i++)
		fprintf(stdout, "%15.02lf", rs->sums[i]);
	fprintf(stdout, "\n");

	//for (i = 0 ; i < qty ; i++)
	//	fprintf(stdout, "%s\n", if_db_get_value(rs, i, "nome"));

	fprintf(stdout, "\nJSON = %s\n", if_db_rs2json(rs, IF_JSON_TYPE_TABLE, "titulo", "### XYZ ###", "teste", "yyyyyyyyyyy", NULL));
	fprintf(stdout, "Qtd. de Linhas: %d\n", rs->num_rows);
	if_db_free_result(rs);

	if_db_close(db);
	
	return(0);
}
// ///////////////////////////////////////////////////////////////////////////

