#include <ifractal.h>


// GETOPT ////////////////////////////////////////////////////////////// //
// ///////////////////////////////////////////////////////////////////// //
_PRIVATE int if_getopt_process(_INOUT IF_GETOPT *opt, int argc, char **argv, int index, int pad)
{
	opt->index = index;
	if (opt->type == IF_GETOPT_TYPE_NONE)
		return(pad);

	if (pad >= argc)
		return(pad + 1);

	if (opt->type == IF_GETOPT_TYPE_NUMBER)
		if (!isNumber(argv[pad]))
			return(index);

	opt->argindex = pad;
	opt->arg = argv[pad++];

	return(pad);
}
// ///////////////////////////////////////////////////////////////////// //
_PRIVATE int if_getopt_process_long(_INOUT IF_GETOPT opts[], _IN int argc, _IN char **argv, _IN int index)
{
	int j, pad;

	// Verifica se o argumento eh o finalizador "--"
	if (strlen(argv[index]) == 2)
		return(argc);

	for (pad = index + 1, j = 0 ; opts[j].long_opt != NULL ; j++)
	{
		if (strcmp(opts[j].long_opt, argv[index] + 2))
			continue;

		pad = if_getopt_process(&(opts[j]), argc, argv, index, pad);
	}

	return(pad);
}
// ///////////////////////////////////////////////////////////////////// //
_PRIVATE int if_getopt_process_opt(_INOUT IF_GETOPT opts[], _IN int argc, _IN char **argv, _IN int index)
{
	int j, k, pad;

	// Podem haver varias opcoes no mesmo indice. Ex. "-ztvf"
	for (pad = index + 1, k = 1 ; argv[index][k] != 0 ; k++)
	{
		for (j = 0 ; opts[j].long_opt != NULL ; j++)
		{
			if (opts[j].opt != argv[index][k])
				continue;

			pad = if_getopt_process(&(opts[j]), argc, argv, index, pad);
			break;
		}

		if (opts[j].long_opt == NULL)
			return(index);
	}

	return(pad);
}
// ///////////////////////////////////////////////////////////////////// //
_PUBLIC int if_getopt(_INOUT IF_GETOPT opts[], _IN int argc, _IN char **argv)
{
	int i, r;

	for (i = 1 ; i < argc ; i = r)
	{
		if (argv[i][0] != '-')
			return(i);
		else if (argv[i][1] != '-')
			r = if_getopt_process_opt(opts, argc, argv, i);
		else
			r = if_getopt_process_long(opts, argc, argv, i);

		// Verifica se opcao era valida
		if (r <= i)
			return(-1);
	}

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
_PUBLIC void if_getopt_verbose(_IN IF_GETOPT opts[])
{
	int j;

	for (j = 0 ; opts[j].long_opt != NULL ; j++)
	{
		if (opts[j].type == IF_GETOPT_TYPE_NONE)
			verbose(stderr, "--%s: %d\n", 
				opts[j].long_opt, 
				if_getopt_isChecked(opts, opts[j].long_opt));
		else
			verbose(stderr, "--%s: '%s'\n", 
				opts[j].long_opt, 
				if_getopt_getValue(opts, opts[j].long_opt));
	}
}
// ///////////////////////////////////////////////////////////////////// //
_PUBLIC void if_getopt_check(_IN IF_GETOPT opts[], _IN char *long_opt)
{
	int j;

	for (j = 0 ; opts[j].long_opt != NULL ; j++)
		if (strcmp(opts[j].long_opt, long_opt) == 0)
			opts[j].index = -1;
}
// ///////////////////////////////////////////////////////////////////// //
_PUBLIC int if_getopt_isChecked(_IN IF_GETOPT opts[], _IN char *long_opt)
{
	int j;

	for (j = 0 ; opts[j].long_opt != NULL ; j++)
		if (strcmp(opts[j].long_opt, long_opt) == 0)
			return(opts[j].index);
	
	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
_PUBLIC char * if_getopt_getValue(_IN IF_GETOPT opts[], _IN char *long_opt)
{
	int j;

	for (j = 0 ; opts[j].long_opt != NULL ; j++)
		if (strcmp(opts[j].long_opt, long_opt) == 0)
			return(opts[j].arg);
	return("");
}
// ///////////////////////////////////////////////////////////////////// //
_PUBLIC int if_getopt_setValue(_IN IF_GETOPT opts[], _IN char *long_opt, _IN char *value)
{
	int j;

	for (j = 0 ; opts[j].long_opt != NULL ; j++)
		if (strcmp(opts[j].long_opt, long_opt) == 0)
			opts[j].arg = value;
	return(j);
}
// ///////////////////////////////////////////////////////////////////// //
_PUBLIC int if_getopt_getIndex(_IN IF_GETOPT opts[], _IN char *long_opt)
{
	int j;

	for (j = 0 ; opts[j].long_opt != NULL ; j++)
		if (strcmp(opts[j].long_opt, long_opt) == 0)
			return(opts[j].argindex);
	return(-1);
}
// ///////////////////////////////////////////////////////////////////// //
_PUBLIC void if_getopt_help(_IN IF_GETOPT opts[])
{
	char buf[PATH_LEN], type = ' ';
	char *help;
	int j;

	for (j = 0 ; opts[j].long_opt != NULL ; j++)
	{
		help = opts[j].help;

		switch (opts[j].type)
		{
			case IF_GETOPT_TYPE_NONE:
				type = 'B';
				break;

			case IF_GETOPT_TYPE_BOOLEAN:
				type = 'B';
				break;

			case IF_GETOPT_TYPE_NUMBER:
				type = 'N';
				break;

			case IF_GETOPT_TYPE_STRING:
				type = 'S';
				break;

			case IF_GETOPT_TYPE_HIDDEN: 
				type = 'H';
				break;

			case IF_GETOPT_TYPE_SELECT: 
				type = 'O';
				help = "Vide opcoes...";
				break;
		}

		snprintf(buf, PATH_LEN, "\t(%c) -%c, --%s", type, opts[j].opt, opts[j].long_opt); 
		fprintf(stderr, "%-30s- %s\n", buf, help);
	}
}
// ///////////////////////////////////////////////////////////////////// //
_PRIVATE void if_help_header2(char *app_name, char *descript, int va, int vb, int vc, int rev, time_t unixtime)
{
	struct tm *dt;

	fprintf(stderr, "\n####################################");
	fprintf(stderr, "\niFractal Desenvolvimento de Software");
	fprintf(stderr, "\n####################################\n\n");

	fprintf(stderr, "Programa: %s\n", app_name);
	fprintf(stderr, "Versao: %d.%d.%d r%d", va, vb, vc, rev);

	dt = localtime(&unixtime);
	fprintf(stderr, " - %02d/%02d/%d %02d:%02d",
		dt->tm_mday, dt->tm_mon + 1, dt->tm_year + 1900,
		dt->tm_hour, dt->tm_min);

	fprintf(stderr, "\nDescricao:\n\t%s\n\n", descript);
}
// ///////////////////////////////////////////////////////////////////// //


// ///////////////////////////////////////////////////////////////////// //
_PUBLIC int if_getopt_ini(_IN char *file, _INOUT IF_GETOPT opts[])
{
	char buf[BUFFER_LEN];
	int i, len, qtd, line;
	FILE *fd;

	for (i = 0 ; opts[i].opt != 0 ; i++)
		opts[i].arg = if_strdup(opts[i].arg);

	fd = fopen(file, "rb");
	if (fd == NULL)
		return(-1);

	for (line = 1, qtd = 0 ; fgets(buf, BUFFER_LEN, fd) != NULL ; line++)
	{
		// limpa finalizadores '\r' '\n'
		for (i = 0 ; buf[i] != 0 ; i++)
			if ((buf[i] == '\r') || (buf[i] == '\n'))
				buf[i] = 0;

		for (i = 0 ; opts[i].opt != 0 ; i++)
		{
			len = strlen(opts[i].long_opt);
			if (strlen(buf) < (len + 1))
				continue;

			if (buf[len] != '=')
				continue;

			if (strncmp(buf, opts[i].long_opt, len))
				continue;

			if_free(opts[i].arg);
			opts[i].arg = if_strdup(buf + len + 1);
			opts[i].index = line;
			opts[i].argindex = len + 1;
			qtd++;
		}
	}

	fclose(fd);

	return(qtd);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
_PUBLIC int if_getopt_save(_IN char *file, _INOUT IF_GETOPT opts[])
{
	time_t now = time(NULL);
	struct tm *dt;
	FILE *fd;
	int i;

	fd = fopen(file, "w");
	if (fd == NULL)
	{
		verbose(stderr, "Falha ao tentar gravar em: '%s'\n", file);
		return(-1);
	}

	dt = localtime(&now);
	fprintf(fd, "# Gerado em %02d/%02d/%d %02d:%02d:%02d\n\n",
		dt->tm_mday, dt->tm_mon + 1, dt->tm_year + 1900,
		dt->tm_hour, dt->tm_min, dt->tm_sec);

	for (i = 0 ; opts[i].long_opt != NULL ; i++)
		fprintf(fd, "%s=%s\n", opts[i].long_opt, opts[i].arg);

	fclose(fd);

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
_PUBLIC int if_getopt_sync(_IN IF_GETOPT in[], _INOUT IF_GETOPT out[])
{
	char *aux;
	int i;

	for (i = 0 ; in[i].long_opt != NULL ; i++)
	{
		aux = if_getopt_getValue(in, in[i].long_opt);
		if_getopt_setValue(out, in[i].long_opt, aux);
	}

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
int if_getopt_key_in_file(char *file, char *key, _OUT char *value, size_t len)
{
	int keylen = strlen(key);
	char line[keylen + len + 1];
	FILE *fd = fopen(file, "r");
	int n = 0;

	if (fd == NULL)
		return(-1);

	while (fgets(line, sizeof(line), fd))
	{
		if (line[keylen] != '=')
			continue;

		if (strncmp(line, key, keylen) != 0)
			continue;

		n = snprintf(value, len, "%s", line + keylen + 1);
		for (int i = 0 ; value[i] != 0 ; i++)
			if ((value[i] == '\r') || (value[i] == '\n'))
				value[i] = 0;
	}

	fclose(fd);

	return(n);
}
// ///////////////////////////////////////////////////////////////////// //


#ifdef DEBUG_GETOPT
IF_GETOPT opts[] = {
	{0, 'a', IF_GETOPT_TYPE_NONE, "flagA", "", 0, "Teste flag."},
	{0, 'b', IF_GETOPT_TYPE_STRING, "strB", "", 0, "Testa string."},
	{0, 'c', IF_GETOPT_TYPE_NUMBER, "numC", "", 0, "Testa parametro Numerico."},
	{0, 'h', IF_GETOPT_TYPE_NONE, "help", "", 0, "Mostra comandos."},
	{0, 0, 0, 0, 0, 0, 0}
};

// ///////////////////////////////////////////////////////////////////// //
int main(int argc, char **argv)
{
	int r;
	
	r = if_getopt(opts, argc, argv);
	if (r)
	{
		fprintf(stderr, "\n### ERROR ###\n");
		if_getopt_verbose(opts);
		return(r);
	}

	if (if_getopt_isChecked(opts, "help"))
	{
		fprintf(stderr, "Uso:\nshell$ %s [OPTIONS]\n", argv[0]);
		if_getopt_help(opts);
		return(1);
	}

	if_getopt_verbose(opts);
	fprintf(stdout, "\n### OK ###\n");
	
	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
#endif


